package gov.va.med.mhv.sm.admin.jpa.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.sm.admin.jpa.model.TriageRelation;

@Repository
public interface TriageRelationRepository extends JpaRepository<TriageRelation, Long> {

	@Query("select tr from TriageRelation tr,PatientTriageMap ptm where "
			+ "tr.id=ptm.relationId and ptm.patientId=:patientId and tr.active=1")
	List<TriageRelation> getTriageGroupRelationsForPatient(@Param("patientId") Long patientId);

	@Query("select tr from TriageRelation tr where "
			+ "tr.triageGroupId=:triageGroupId and tr.relationTypeId=0 and tr.active=1")
	List<TriageRelation> getPCMMProvidersByTriageGroup(@Param("triageGroupId") Long triageGroupId);

	@Query("select tr from TriageRelation tr where "
			+ "tr.triageGroupId=:triageGroupId and tr.relationTypeId=2 and tr.active=1")
	List<TriageRelation> getOERRTeamsByTriageGroup(@Param("triageGroupId") Long triageGroupId);

	@Query("select tr from TriageRelation tr where "
			+ "tr.triageGroupId=:triageGroupId and tr.relationTypeId=1 and tr.active=1")
	List<TriageRelation> getClinicsByTriageGroup(@Param("triageGroupId") Long triageGroupId);

	@Query("select tr from TriageRelation tr where "
			+ "tr.triageGroupId=:triageGroupId and tr.relationTypeId=6 and tr.active=1")
	List<TriageRelation> getPatientsByTriageGroup(@Param("triageGroupId") Long triageGroupId);

}